INSERT INTO Types (Type, Kind)
	VALUES
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "KIND_ABILITY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "KIND_ABILITY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "KIND_ABILITY");

INSERT INTO TypeTags (Type, Tag)
	VALUES
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_RECON"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_MELEE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_RANGED"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_ANTI_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_SIEGE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_HEAVY_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_HEAVY_CHARIOT"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_LIGHT_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "CLASS_RANGED_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_RECON"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_MELEE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_RANGED"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_ANTI_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_SIEGE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_HEAVY_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_HEAVY_CHARIOT"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_LIGHT_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "CLASS_RANGED_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_RECON"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_MELEE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_RANGED"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_ANTI_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_SIEGE"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_HEAVY_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_HEAVY_CHARIOT"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_LIGHT_CAVALRY"),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "CLASS_RANGED_CAVALRY");

/* CREATE MODIFIER GENERATOR FRAMEWORK -- DO NOT CHANGE */
--Temporary tables dropped at end
CREATE TABLE FortModTempTable
	(
	ModifierId TEXT NOT NULL,
	RunOnce BOOLEAN NOT NULL DEFAULT 0,
	Permanent BOOLEAN NOT NULL DEFAULT 0,
	OwnerRequirementSetId TEXT,
	SubjectRequirementSetId TEXT,
	ModifierType TEXT NOT NULL,
	Name TEXT,
	Value TEXT,
	Extra TEXT,
	Name2 TEXT,
	Value2 TEXT,
	Extra2 TEXT,
	Name3 TEXT,
	Value3 TEXT,
	Extra3 TEXT,
	Name4 TEXT,
	Value4 TEXT,
	Extra4 TEXT,
	Name5 TEXT,
	Value5 TEXT,
	Extra5 TEXT,
	AttachedTo TEXT
	);

CREATE TABLE FortReqTempTable
	(
	RequirementSetId TEXT,
	RequirementSetType TEXT,
	RequirementId TEXT,
	RequirementType TEXT,
	Inverse BOOLEAN NOT NULL DEFAULT 0,
	Name TEXT,
	Value TEXT,
	Extra TEXT,
	Name2 TEXT,
	Value2 TEXT,
	Extra2 TEXT
	);
/* END CREATE FRAMEWORK */

/* NEW UNIT ABILITIES */		
INSERT INTO UnitAbilities (UnitAbilityType, Name, Description, Inactive)
	VALUES
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT_NAME", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT_DESCRIPTION", 0),
		("ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL_NAME", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL_DESCRIPTION", 0),
		("ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH_NAME", "LOC_ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH_DESCRIPTION", 0);

/* CREATE NEW MODIFIERS */
--INPUT MODIFIERS
INSERT INTO FortModTempTable (ModifierId, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId, ModifierType, Name, Value, Extra, Name2, Value2, Extra2, Name3, Value3, Extra3, Name4, Value4, Extra4, Name5, Value5, Extra5, AttachedTo)
	VALUES
		("DEFENSIVEIMPROVEMENT_BONUS_SIGHT", 0, 0, NULL, "IMPROVEMENT_IS_DEFENSIVE", "MODIFIER_PLAYER_UNIT_ADJUST_SIGHT", "Amount", 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_SIGHT"),
		("DEFENSIVEIMPROVEMENT_BONUS_HEAL", 0, 0, NULL, "IMPROVEMENT_IS_DEFENSIVE", "MODIFIER_PLAYER_UNIT_ADJUST_HEAL_PER_TURN", "Amount", 5, NULL, "Type", "ALL", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "ABILITY_DEFENSIVE_IMPROVEMENT_BONUS_HEAL"),
		("DEFENSIVEIMPROVEMENT_REVEAL_STEALTH", 0, 0, NULL, "IMPROVEMENT_IS_DEFENSIVE", "MODIFIER_PLAYER_UNIT_ADJUST_SEE_HIDDEN", "SeeHidden", "true", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "ABILITY_DEFENSIVE_IMPROVEMENT_REVEAL_STEALTH");

--INPUT REQUIREMENTS
INSERT INTO FortReqTempTable (RequirementSetId, RequirementSetType, RequirementId, RequirementType, Inverse, Name, Value, Extra, Name2, Value2, Extra2)
	VALUES
		("IMPROVEMENT_IS_DEFENSIVE", "REQUIREMENTSET_TEST_ANY", "REQUIRES_FORT_IN_PLOT", "REQUIREMENT_PLOT_IMPROVEMENT_TYPE_MATCHES", 0, "ImprovementType", "IMPROVEMENT_FORT", NULL, NULL, NULL, NULL),
		("IMPROVEMENT_IS_DEFENSIVE", "REQUIREMENTSET_TEST_ANY", "REQUIRES_ROMANFORT_IN_PLOT", "REQUIREMENT_PLOT_IMPROVEMENT_TYPE_MATCHES", 0, "ImprovementType", "IMPROVEMENT_ROMAN_FORT", NULL, NULL, NULL, NULL),
		("IMPROVEMENT_IS_DEFENSIVE", "REQUIREMENTSET_TEST_ANY", "REQUIRES_GREATWALL_IN_PLOT", "REQUIREMENT_PLOT_IMPROVEMENT_TYPE_MATCHES", 0, "ImprovementType", "IMPROVEMENT_GREAT_WALL", NULL, NULL, NULL, NULL);

/* MODIFIER AUTO-GENERATION -- DO NOT CHANGE ANYTHING BELOW HERE */
--MODIFIER INSERTS
--Populate Modifiers table
INSERT INTO Modifiers (ModifierId, ModifierType, OwnerRequirementSetId, SubjectRequirementSetId, RunOnce, Permanent)
	SELECT FortModTempTable.ModifierId, FortModTempTable.ModifierType, FortModTempTable.OwnerRequirementSetId, FortModTempTable.SubjectRequirementSetId, FortModTempTable.RunOnce, FortModTempTable.Permanent FROM FortModTempTable;

--Populate ModifierArguments table first set
INSERT INTO ModifierArguments (ModifierId, Name, Value, Extra)
	SELECT FortModTempTable.ModifierId, FortModTempTable.Name, FortModTempTable.Value, FortModTempTable.Extra FROM FortModTempTable;

--Populate ModifierArguments table second set	
INSERT INTO ModifierArguments (ModifierId, Name, Value, Extra)
	SELECT FortModTempTable.ModifierId, FortModTempTable.Name2, FortModTempTable.Value2, FortModTempTable.Extra2 FROM FortModTempTable
	WHERE FortModTempTable.Name2 IS NOT NULL;

--Populate ModifierArguments table third set	
INSERT INTO ModifierArguments (ModifierId, Name, Value, Extra)
	SELECT FortModTempTable.ModifierId, FortModTempTable.Name3, FortModTempTable.Value3, FortModTempTable.Extra3 FROM FortModTempTable
	WHERE FortModTempTable.Name3 IS NOT NULL;

--Populate ModifierArguments table fourth set	
INSERT INTO ModifierArguments (ModifierId, Name, Value, Extra)
	SELECT FortModTempTable.ModifierId, FortModTempTable.Name4, FortModTempTable.Value4, FortModTempTable.Extra4 FROM FortModTempTable
	WHERE FortModTempTable.Name4 IS NOT NULL;

--Populate ModifierArguments table fifth set	
INSERT INTO ModifierArguments (ModifierId, Name, Value, Extra)
	SELECT FortModTempTable.ModifierId, FortModTempTable.Name5, FortModTempTable.Value5, FortModTempTable.Extra5 FROM FortModTempTable
	WHERE FortModTempTable.Name5 IS NOT NULL;	
	
--REQUIREMENT INSERTS
--Populate Requirements table
INSERT INTO Requirements (RequirementId, RequirementType, Inverse)
	SELECT FortReqTempTable.RequirementId, FortReqTempTable.RequirementType, FortReqTempTable.Inverse FROM FortReqTempTable;

--Populate RequirementArguments table first set
INSERT INTO RequirementArguments (RequirementId, Name, Value, Extra)
	SELECT FortReqTempTable.RequirementId, FortReqTempTable.Name, FortReqTempTable.Value, FortReqTempTable.Extra FROM FortReqTempTable
	WHERE FortReqTempTable.Name IS NOT NULL;

--Populate RequirementArguments table second set
INSERT INTO RequirementArguments (RequirementId, Name, Value, Extra)
	SELECT FortReqTempTable.RequirementId, FortReqTempTable.Name2, FortReqTempTable.Value2, FortReqTempTable.Extra2 FROM FortReqTempTable
	WHERE FortReqTempTable.Name2 IS NOT NULL;

--Populate RequirementSetRequirements table
INSERT INTO RequirementSetRequirements (RequirementSetId, RequirementId)
	SELECT FortReqTempTable.RequirementSetId, FortReqTempTable.RequirementId FROM FortReqTempTable;

--Populate RequirementSets table with only unique values	
INSERT INTO RequirementSets (RequirementSetId, RequirementSetType)
	SELECT DISTINCT FortReqTempTable.RequirementSetId, FortReqTempTable.RequirementSetType FROM FortReqTempTable;

--ATTACH MODIFIERS
--Attach Unit Ability modifiers
INSERT INTO UnitAbilityModifiers (UnitAbilityType, ModifierId)
	SELECT FortModTempTable.AttachedTo, FortModTempTable.ModifierId FROM FortModTempTable
	WHERE FortModTempTable.AttachedTo LIKE 'ABILITY%';	
	
--DROP TABLES
DROP TABLE FortModTempTable;
DROP TABLE FortReqTempTable;